//
//  OPImageDownloadOperation.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-10-21.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AgileLibrary/AgileLibrary.h>
#import <OnePasswordCore/OnePasswordCore.h>
#import <OnePasswordDataModel/OnePasswordDataModel.h>

#import "OPImageService.h"

@class OPImageDownloadOperation;

@protocol OPImageDownloadOperationDelegate <NSObject>
- (void)imageDownloadOperation:(OPImageDownloadOperation *)operation completedWithLocalImage:(OPImage *)image;
- (void)imageDownloadOperation:(OPImageDownloadOperation *)operation completedWithNetworkImage:(OPImage *)image;
- (void)imageDownloadOperation:(OPImageDownloadOperation *)operation didFailWithStatusCode:(NSInteger)statusCode error:(NSError *)error;
@end

@interface OPImageDownloadOperation : NSOperation

@property (nonatomic, strong) id<OPGenericProfile> profile;
@property (nonatomic, strong) AGReachability * reachability;
@property (nonatomic, strong) OPImage * matchingSizeOverlay;
@property (nonatomic, strong) OPImage * smallSizeOverlay;
@property (nonatomic, strong) OPImage * overlayMask;
@property (nonatomic) CGFloat imageSize;
@property (nonatomic) CGFloat imageScale;
@property (nonatomic, strong) NSString * localName;
@property (nonatomic, strong) NSURL * localFileURL;
@property (nonatomic, strong) FetchImageBlock fetchImageBlock;
@property (nonatomic, readonly) NSURLRequest *urlRequest;

@property (nonatomic, weak) id<OPImageDownloadOperationDelegate> delegate;

- (instancetype)initWithRequest:(NSURLRequest *)urlRequest session:(NSURLSession *)urlSession;

@end
